%%%
%%% you are welcome to use this tool for research purpose, however, you may consider citing the following papers:
%%% [1] Nicholas Jing Yuan, Yu Zheng and Xing Xie, Segmentation of Urban Areas Using Road Networks, MSR TR-2012-65
%%% [2] Yu Zheng, Yanchi Liu, Jing Yuan, and Xing Xie. Urban Computing with Taxicabs, ACM Ubicomp, 2011.
%%%

clear all;

J = imread('NYC_Roads.bmp');
Q = J(:,:,1);
Q = logical(Q);

J = imread('NYC_boundary_filled.bmp');
K = J(:,:,1);
P = find(K==160);
K = logical(K);
K = 1 - K;

I = Q & K;
I(P) = 1;

figure;
I = logical(I);

%% original map
% subplot(2,2,1);
% imshow(I);
% title('original');

%% dilation
% subplot(2,2,2);
I=bwmorph(I,'dilate',2);
% imshow(I);
% title('after dilation');

%% thinning
% subplot(2,2,3);
I=bwmorph(I,'thin',Inf);
% imshow(I);
% title('after thinning');

%% connected component labeling
% subplot(2,2,4);
I=1-I;
bwmatrix=bwlabel(I,4);

%% Sea
bwmatrix(bwmatrix == 696) = 0;
bwmatrix(bwmatrix == 697) = 0;
bwmatrix(bwmatrix == 711) = 0;
bwmatrix(bwmatrix == 702) = 0;
bwmatrix(bwmatrix == 712) = 0;
bwmatrix(bwmatrix == 722) = 0;
bwmatrix(bwmatrix == 183) = 0;
bwmatrix(bwmatrix == 241) = 0;
bwmatrix(bwmatrix == 242) = 0;
bwmatrix(bwmatrix == 273) = 0;
bwmatrix(bwmatrix == 344) = 0;
bwmatrix(bwmatrix == 389) = 0;
bwmatrix(bwmatrix == 196) = 0;
bwmatrix(bwmatrix == 198) = 0;
bwmatrix(bwmatrix == 199) = 0;
bwmatrix(bwmatrix == 200) = 0;
bwmatrix(bwmatrix == 209) = 0;
bwmatrix(bwmatrix == 210) = 0;
bwmatrix(bwmatrix == 211) = 0;
bwmatrix(bwmatrix == 192) = 0;
bwmatrix(bwmatrix == 197) = 0;
bwmatrix(bwmatrix == 188) = 0;
bwmatrix(bwmatrix == 189) = 0;
bwmatrix(bwmatrix == 204) = 0;
bwmatrix(bwmatrix == 212) = 0;
bwmatrix(bwmatrix == 233) = 0;
bwmatrix(bwmatrix == 235) = 0;
bwmatrix(bwmatrix == 227) = 0;
bwmatrix(bwmatrix == 220) = 0;
bwmatrix(bwmatrix == 213) = 0;
bwmatrix(bwmatrix == 231) = 0;
bwmatrix(bwmatrix == 221) = 0;
bwmatrix(bwmatrix == 252) = 0;
bwmatrix(bwmatrix == 225) = 0;
bwmatrix(bwmatrix == 223) = 0;
bwmatrix(bwmatrix == 288) = 0;
bwmatrix(bwmatrix == 270) = 0;
bwmatrix(bwmatrix == 616) = 0;
bwmatrix(bwmatrix == 535) = 0;
bwmatrix(bwmatrix == 130) = 0;
bwmatrix(bwmatrix == 156) = 0;
bwmatrix(bwmatrix == 159) = 0;
bwmatrix(bwmatrix == 162) = 0;
bwmatrix(bwmatrix == 163) = 0;
bwmatrix(bwmatrix == 164) = 0;
bwmatrix(bwmatrix == 167) = 0;
bwmatrix(bwmatrix == 169) = 0;
bwmatrix(bwmatrix == 170) = 0;
bwmatrix(bwmatrix == 172) = 0;
bwmatrix(bwmatrix == 173) = 0;
bwmatrix(bwmatrix == 174) = 0;
bwmatrix(bwmatrix == 175) = 0;
bwmatrix(bwmatrix == 251) = 0;
bwmatrix(bwmatrix == 367) = 0;
bwmatrix(bwmatrix == 405) = 0;
bwmatrix(bwmatrix == 513) = 0;
bwmatrix(bwmatrix == 532) = 0;
bwmatrix(bwmatrix == 587) = 0;
bwmatrix(bwmatrix == 738) = 0;
bwmatrix(bwmatrix == 1025) = 0;
bwmatrix(bwmatrix == 1048) = 0;
bwmatrix(bwmatrix == 116) = 0;
bwmatrix(bwmatrix == 117) = 0;
bwmatrix(bwmatrix == 119) = 0;
bwmatrix(bwmatrix == 122) = 0;
bwmatrix(bwmatrix == 123) = 0;
bwmatrix(bwmatrix == 124) = 0;
bwmatrix(bwmatrix == 125) = 0;
bwmatrix(bwmatrix == 126) = 0;
bwmatrix(bwmatrix == 2) = 0;
bwmatrix(bwmatrix == 3) = 0;
bwmatrix(bwmatrix == 25) = 0;
bwmatrix(bwmatrix == 152) = 0;
bwmatrix(bwmatrix == 734) = 0;
bwmatrix(bwmatrix == 746) = 0;
bwmatrix(bwmatrix == 777) = 0;
bwmatrix(bwmatrix == 827) = 0;
bwmatrix(bwmatrix == 1011) = 0;
bwmatrix(bwmatrix == 73) = 0;
bwmatrix(bwmatrix == 115) = 0;
bwmatrix(bwmatrix == 121) = 0;
bwmatrix(bwmatrix == 127) = 0;
bwmatrix(bwmatrix == 128) = 0;
bwmatrix(bwmatrix == 131) = 0;
bwmatrix(bwmatrix == 132) = 0;
bwmatrix(bwmatrix == 133) = 0;
bwmatrix(bwmatrix == 134) = 0;
bwmatrix(bwmatrix == 135) = 0;
bwmatrix(bwmatrix == 137) = 0;
bwmatrix(bwmatrix == 138) = 0;
bwmatrix(bwmatrix == 140) = 0;
bwmatrix(bwmatrix == 141) = 0;
bwmatrix(bwmatrix == 142) = 0;
bwmatrix(bwmatrix == 143) = 0;
bwmatrix(bwmatrix == 144) = 0;
bwmatrix(bwmatrix == 145) = 0;
bwmatrix(bwmatrix == 147) = 0;
bwmatrix(bwmatrix == 148) = 0;
bwmatrix(bwmatrix == 149) = 0;
bwmatrix(bwmatrix == 150) = 0;
bwmatrix(bwmatrix == 151) = 0;
bwmatrix(bwmatrix == 153) = 0;
bwmatrix(bwmatrix == 154) = 0;

%% area == 1
bwmatrix(bwmatrix == 994) = 0;
bwmatrix(bwmatrix == 908) = 0;
bwmatrix(bwmatrix == 1065) = 0;
bwmatrix(bwmatrix == 855) = 0;
bwmatrix(bwmatrix == 852) = 0;
bwmatrix(bwmatrix == 1028) = 0;
bwmatrix(bwmatrix == 832) = 0;
bwmatrix(bwmatrix == 811) = 0;
bwmatrix(bwmatrix == 810) = 0;
bwmatrix(bwmatrix == 805) = 0;
bwmatrix(bwmatrix == 959) = 0;
bwmatrix(bwmatrix == 802) = 0;
bwmatrix(bwmatrix == 700) = 0;
bwmatrix(bwmatrix == 720) = 0;
bwmatrix(bwmatrix == 775) = 0;
bwmatrix(bwmatrix == 687) = 0;
bwmatrix(bwmatrix == 898) = 0;
bwmatrix(bwmatrix == 893) = 0;
bwmatrix(bwmatrix == 689) = 0;
bwmatrix(bwmatrix == 779) = 0;
bwmatrix(bwmatrix == 541) = 0;
bwmatrix(bwmatrix == 699) = 0;
bwmatrix(bwmatrix == 512) = 0;
bwmatrix(bwmatrix == 510) = 0;
bwmatrix(bwmatrix == 721) = 0;
bwmatrix(bwmatrix == 484) = 0;
bwmatrix(bwmatrix == 479) = 0;
bwmatrix(bwmatrix == 470) = 0;
bwmatrix(bwmatrix == 649) = 0;
bwmatrix(bwmatrix == 1051) = 0;
bwmatrix(bwmatrix == 950) = 0;
bwmatrix(bwmatrix == 780) = 0;
bwmatrix(bwmatrix == 1190) = 0;
bwmatrix(bwmatrix == 907) = 0;
bwmatrix(bwmatrix == 1191) = 0;
bwmatrix(bwmatrix == 1194) = 0;
bwmatrix(bwmatrix == 1196) = 0;
bwmatrix(bwmatrix == 494) = 0;
bwmatrix(bwmatrix == 504) = 0;
bwmatrix(bwmatrix == 507) = 0;
bwmatrix(bwmatrix == 519) = 0;
bwmatrix(bwmatrix == 520) = 0;
bwmatrix(bwmatrix == 557) = 0;
bwmatrix(bwmatrix == 559) = 0;
bwmatrix(bwmatrix == 527) = 0;
bwmatrix(bwmatrix == 536) = 0;
bwmatrix(bwmatrix == 325) = 0;
bwmatrix(bwmatrix == 554) = 0;
bwmatrix(bwmatrix == 355) = 0;
bwmatrix(bwmatrix == 360) = 0;
bwmatrix(bwmatrix == 356) = 0;
bwmatrix(bwmatrix == 679) = 0;
bwmatrix(bwmatrix == 403) = 0;
bwmatrix(bwmatrix == 409) = 0;
bwmatrix(bwmatrix == 416) = 0;
bwmatrix(bwmatrix == 1142) = 0;
bwmatrix(bwmatrix == 508) = 0;
bwmatrix(bwmatrix == 506) = 0;
bwmatrix(bwmatrix == 630) = 0;
bwmatrix(bwmatrix == 1147) = 0;
bwmatrix(bwmatrix == 219) = 0;
bwmatrix(bwmatrix == 292) = 0;
bwmatrix(bwmatrix == 716) = 0;
bwmatrix(bwmatrix == 412) = 0;
bwmatrix(bwmatrix == 928) = 0;
bwmatrix(bwmatrix == 710) = 0;
bwmatrix(bwmatrix == 707) = 0;
bwmatrix(bwmatrix == 1174) = 0;
bwmatrix(bwmatrix == 411) = 0;
bwmatrix(bwmatrix == 948) = 0;
bwmatrix(bwmatrix == 884) = 0;
bwmatrix(bwmatrix == 255) = 0;
bwmatrix(bwmatrix == 286) = 0;
bwmatrix(bwmatrix == 1150) = 0;
bwmatrix(bwmatrix == 357) = 0;
bwmatrix(bwmatrix == 354) = 0;
bwmatrix(bwmatrix == 352) = 0;
bwmatrix(bwmatrix == 306) = 0;
bwmatrix(bwmatrix == 307) = 0;
bwmatrix(bwmatrix == 329) = 0;
bwmatrix(bwmatrix == 278) = 0;
bwmatrix(bwmatrix == 272) = 0;
bwmatrix(bwmatrix == 208) = 0;
bwmatrix(bwmatrix == 1032) = 0;
bwmatrix(bwmatrix == 1031) = 0;
bwmatrix(bwmatrix == 265) = 0;
bwmatrix(bwmatrix == 264) = 0;
bwmatrix(bwmatrix == 263) = 0;
bwmatrix(bwmatrix == 257) = 0;
bwmatrix(bwmatrix == 253) = 0;
bwmatrix(bwmatrix == 862) = 0;
bwmatrix(bwmatrix == 201) = 0;
bwmatrix(bwmatrix == 566) = 0;
bwmatrix(bwmatrix == 303) = 0;
bwmatrix(bwmatrix == 302) = 0;
bwmatrix(bwmatrix == 300) = 0;
bwmatrix(bwmatrix == 297) = 0;
bwmatrix(bwmatrix == 293) = 0;
bwmatrix(bwmatrix == 290) = 0;
bwmatrix(bwmatrix == 287) = 0;
bwmatrix(bwmatrix == 284) = 0;
bwmatrix(bwmatrix == 269) = 0;
bwmatrix(bwmatrix == 249) = 0;
bwmatrix(bwmatrix == 206) = 0;
bwmatrix(bwmatrix == 881) = 0;
bwmatrix(bwmatrix == 883) = 0;
bwmatrix(bwmatrix == 217) = 0;
bwmatrix(bwmatrix == 218) = 0;
bwmatrix(bwmatrix == 920) = 0;
bwmatrix(bwmatrix == 472) = 0;
bwmatrix(bwmatrix == 184) = 0;
bwmatrix(bwmatrix == 961) = 0;
bwmatrix(bwmatrix == 187) = 0;
bwmatrix(bwmatrix == 347) = 0;
bwmatrix(bwmatrix == 345) = 0;
bwmatrix(bwmatrix == 342) = 0;
bwmatrix(bwmatrix == 337) = 0;
bwmatrix(bwmatrix == 333) = 0;
bwmatrix(bwmatrix == 330) = 0;
bwmatrix(bwmatrix == 327) = 0;
bwmatrix(bwmatrix == 323) = 0;
bwmatrix(bwmatrix == 812) = 0;
bwmatrix(bwmatrix == 315) = 0;
bwmatrix(bwmatrix == 814) = 0;
bwmatrix(bwmatrix == 825) = 0;
bwmatrix(bwmatrix == 823) = 0;
bwmatrix(bwmatrix == 537) = 0;
bwmatrix(bwmatrix == 413) = 0;
bwmatrix(bwmatrix == 464) = 0;
bwmatrix(bwmatrix == 466) = 0;
bwmatrix(bwmatrix == 168) = 0;
bwmatrix(bwmatrix == 164) = 0;
bwmatrix(bwmatrix == 161) = 0;
bwmatrix(bwmatrix == 160) = 0;
bwmatrix(bwmatrix == 158) = 0;
bwmatrix(bwmatrix == 157) = 0;
bwmatrix(bwmatrix == 155) = 0;
bwmatrix(bwmatrix == 1121) = 0;
bwmatrix(bwmatrix == 1119) = 0;
bwmatrix(bwmatrix == 1134) = 0;
bwmatrix(bwmatrix == 1133) = 0;
bwmatrix(bwmatrix == 1132) = 0;
bwmatrix(bwmatrix == 1130) = 0;
bwmatrix(bwmatrix == 1175) = 0;
bwmatrix(bwmatrix == 214) = 0;
bwmatrix(bwmatrix == 194) = 0;
bwmatrix(bwmatrix == 139) = 0;
bwmatrix(bwmatrix == 44) = 0;
bwmatrix(bwmatrix == 45) = 0;
bwmatrix(bwmatrix == 68) = 0;
bwmatrix(bwmatrix == 207) = 0;
bwmatrix(bwmatrix == 673) = 0;
bwmatrix(bwmatrix == 129) = 0;
bwmatrix(bwmatrix == 178) = 0;
bwmatrix(bwmatrix == 245) = 0;
bwmatrix(bwmatrix == 244) = 0;
bwmatrix(bwmatrix == 243) = 0;
bwmatrix(bwmatrix == 239) = 0;
bwmatrix(bwmatrix == 238) = 0;
bwmatrix(bwmatrix == 594) = 0;
bwmatrix(bwmatrix == 107) = 0;
bwmatrix(bwmatrix == 63) = 0;
bwmatrix(bwmatrix == 237) = 0;
bwmatrix(bwmatrix == 236) = 0;
bwmatrix(bwmatrix == 136) = 0;
bwmatrix(bwmatrix == 234) = 0;
bwmatrix(bwmatrix == 230) = 0;
bwmatrix(bwmatrix == 146) = 0;
bwmatrix(bwmatrix == 429) = 0;
bwmatrix(bwmatrix == 102) = 0;
bwmatrix(bwmatrix == 101) = 0;
bwmatrix(bwmatrix == 222) = 0;
bwmatrix(bwmatrix == 34) = 0;
bwmatrix(bwmatrix == 33) = 0;
bwmatrix(bwmatrix == 114) = 0;
bwmatrix(bwmatrix == 393) = 0;
bwmatrix(bwmatrix == 1074) = 0;
bwmatrix(bwmatrix == 414) = 0;
bwmatrix(bwmatrix == 88) = 0;
bwmatrix(bwmatrix == 47) = 0;
bwmatrix(bwmatrix == 18) = 0;
bwmatrix(bwmatrix == 17) = 0;
bwmatrix(bwmatrix == 120) = 0;
bwmatrix(bwmatrix == 118) = 0;
bwmatrix(bwmatrix == 10) = 0;

%% area < 50
bwmatrix(bwmatrix == 854) = 0;
bwmatrix(bwmatrix == 800) = 0;
bwmatrix(bwmatrix == 690) = 0;
bwmatrix(bwmatrix == 701) = 0;
bwmatrix(bwmatrix == 706) = 0;
bwmatrix(bwmatrix == 708) = 0;
bwmatrix(bwmatrix == 714) = 0;
bwmatrix(bwmatrix == 715) = 0;
bwmatrix(bwmatrix == 468) = 0;
bwmatrix(bwmatrix == 471) = 0;
bwmatrix(bwmatrix == 442) = 0;
bwmatrix(bwmatrix == 488) = 0;
bwmatrix(bwmatrix == 496) = 0;
bwmatrix(bwmatrix == 499) = 0;
bwmatrix(bwmatrix == 505) = 0;
bwmatrix(bwmatrix == 509) = 0;
bwmatrix(bwmatrix == 511) = 0;
bwmatrix(bwmatrix == 514) = 0;
bwmatrix(bwmatrix == 530) = 0;
bwmatrix(bwmatrix == 311) = 0;
bwmatrix(bwmatrix == 349) = 0;
bwmatrix(bwmatrix == 395) = 0;
bwmatrix(bwmatrix == 386) = 0;
bwmatrix(bwmatrix == 657) = 0;
bwmatrix(bwmatrix == 275) = 0;
bwmatrix(bwmatrix == 277) = 0;
bwmatrix(bwmatrix == 271) = 0;
bwmatrix(bwmatrix == 658) = 0;
bwmatrix(bwmatrix == 659) = 0;
bwmatrix(bwmatrix == 660) = 0;
bwmatrix(bwmatrix == 910) = 0;
bwmatrix(bwmatrix == 954) = 0;
bwmatrix(bwmatrix == 343) = 0;
bwmatrix(bwmatrix == 341) = 0;
bwmatrix(bwmatrix == 332) = 0;
bwmatrix(bwmatrix == 326) = 0;
bwmatrix(bwmatrix == 317) = 0;
bwmatrix(bwmatrix == 313) = 0;
bwmatrix(bwmatrix == 309) = 0;
bwmatrix(bwmatrix == 176) = 0;
bwmatrix(bwmatrix == 42) = 0;
bwmatrix(bwmatrix == 66) = 0;
bwmatrix(bwmatrix == 65) = 0;
bwmatrix(bwmatrix == 106) = 0;
bwmatrix(bwmatrix == 58) = 0;
bwmatrix(bwmatrix == 392) = 0;
bwmatrix(bwmatrix == 394) = 0;
bwmatrix(bwmatrix == 400) = 0;
bwmatrix(bwmatrix == 91) = 0;

bwmatrix(bwmatrix == 1) = 0;
%%

I=bwlabel(bwmatrix,4);

imshow(I);
title('after ccl');

print -dpdf NYC_temp.pdf;
% dlmwrite('NYC_862.txt',I,'delimiter','\t');
